<?php
/*****************************************************************************
 *                                                                           *
 * Shop-Script PREMIUM                                                       *
 * Copyright (c) 2005 WebAsyst LLC. All rights reserved.                     *
 *                                                                           *
 *****************************************************************************/
?><?php
/**
 * @package Services_PayPal
 */

/**
 * Make sure our parent class is defined.
 */
require_once 'Services/PayPal/Type/AbstractResponseType.php';

/**
 * TransactionSearchResponseType
 *
 * @package Services_PayPal
 */
class TransactionSearchResponseType extends AbstractResponseType
{
    var $PaymentTransactions;

    function TransactionSearchResponseType()
    {
        parent::AbstractResponseType();
        $this->_namespace = 'urn:ebay:api:PayPalAPI';
        $this->_elements = array_merge($this->_elements,
            array (
              'PaymentTransactions' => 
              array (
                'required' => false,
                'type' => 'PaymentTransactionSearchResultType',
                'namespace' => 'urn:ebay:apis:eBLBaseComponents',
              ),
            ));
    }

    function getPaymentTransactions()
    {
        return $this->PaymentTransactions;
    }
    function setPaymentTransactions($PaymentTransactions, $charset = 'iso-8859-1')
    {
        $this->PaymentTransactions = $PaymentTransactions;
        $this->_elements['PaymentTransactions']['charset'] = $charset;
    }
}
