<?php
/*****************************************************************************
 *                                                                           *
 * Shop-Script PREMIUM                                                       *
 * Copyright (c) 2005 WebAsyst LLC. All rights reserved.                     *
 *                                                                           *
 *****************************************************************************/
?><?php
/**
 * @package Services_PayPal
 */

/**
 * Make sure our parent class is defined.
 */
require_once 'Services/PayPal/Type/XSDType.php';

/**
 * PaymentTransactionType
 * 
 * PaymentTransactionType - Type declaration to be used by other schemas.
 * Information about a PayPal payment from the seller side
 *
 * @package Services_PayPal
 */
class PaymentTransactionType extends XSDType
{
    var $ReceiverInfo;

    var $PayerInfo;

    var $PaymentInfo;

    var $PaymentItemInfo;

    function PaymentTransactionType()
    {
        parent::XSDType();
        $this->_namespace = 'urn:ebay:apis:eBLBaseComponents';
        $this->_elements = array_merge($this->_elements,
            array (
              'ReceiverInfo' => 
              array (
                'required' => true,
                'type' => 'ReceiverInfoType',
                'namespace' => 'urn:ebay:apis:eBLBaseComponents',
              ),
              'PayerInfo' => 
              array (
                'required' => true,
                'type' => 'PayerInfoType',
                'namespace' => 'urn:ebay:apis:eBLBaseComponents',
              ),
              'PaymentInfo' => 
              array (
                'required' => true,
                'type' => 'PaymentInfoType',
                'namespace' => 'urn:ebay:apis:eBLBaseComponents',
              ),
              'PaymentItemInfo' => 
              array (
                'required' => false,
                'type' => 'PaymentItemInfoType',
                'namespace' => 'urn:ebay:apis:eBLBaseComponents',
              ),
            ));
    }

    function getReceiverInfo()
    {
        return $this->ReceiverInfo;
    }
    function setReceiverInfo($ReceiverInfo, $charset = 'iso-8859-1')
    {
        $this->ReceiverInfo = $ReceiverInfo;
        $this->_elements['ReceiverInfo']['charset'] = $charset;
    }
    function getPayerInfo()
    {
        return $this->PayerInfo;
    }
    function setPayerInfo($PayerInfo, $charset = 'iso-8859-1')
    {
        $this->PayerInfo = $PayerInfo;
        $this->_elements['PayerInfo']['charset'] = $charset;
    }
    function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    function setPaymentInfo($PaymentInfo, $charset = 'iso-8859-1')
    {
        $this->PaymentInfo = $PaymentInfo;
        $this->_elements['PaymentInfo']['charset'] = $charset;
    }
    function getPaymentItemInfo()
    {
        return $this->PaymentItemInfo;
    }
    function setPaymentItemInfo($PaymentItemInfo, $charset = 'iso-8859-1')
    {
        $this->PaymentItemInfo = $PaymentItemInfo;
        $this->_elements['PaymentItemInfo']['charset'] = $charset;
    }
}
