<?php
/*****************************************************************************
 *                                                                           *
 * Shop-Script PREMIUM                                                       *
 * Copyright (c) 2005 WebAsyst LLC. All rights reserved.                     *
 *                                                                           *
 *****************************************************************************/

	include("./core_functions/functions.php");
	include("./core_functions/xml_parser.php");
	include("./core_functions/xml_installer/xml_installer.php");
	include("./core_functions/serialization_functions.php");
	include("./core_functions/order_status_functions.php" );
	include("./core_functions/setting_functions.php");
	include("./core_functions/category_functions.php");
	include("./core_functions/registration_functions.php" );
	include("./core_functions/statistic_functions.php" );
	include("./core_functions/datetime_functions.php" );
	include("./core_functions/aux_pages_functions.php" );
	include("./core_functions/crypto/crypto_functions.php" );
	include("./install/consts.php");
	include("./install/upgrade_ssfree10_sspremium.php");
	include("./install/upgrade_sspro10_sspremium.php"); 
	include("./core_functions/payment_functions.php");
	include("./cfg/paths.inc.php" ); 
	include("./core_functions/version_function.php");

	session_start();

	@set_time_limit(0);

	MagicQuotesRuntimeSetting();

	function _testWriteable()
	{
		if ( !IsWriteable( DATABASE_STRUCTURE_XML_PATH ) )
			return STRING_COULDNT_REWRITE_FILE." ".DATABASE_STRUCTURE_XML_PATH;
		if ( !IsWriteable(TABLES_INC_PHP_PATH) )
			return STRING_COULDNT_REWRITE_FILE." ".TABLES_INC_PHP_PATH;
		if ( !IsWriteable(CONNECT_INC_PHP_PATH) )
			return STRING_COULDNT_REWRITE_FILE." ".CONNECT_INC_PHP_PATH;
		if ( file_exists(RESULT_XML_PATH) )
		{
			if ( !IsWriteable(RESULT_XML_PATH) )
				return STRING_COULDNT_REWRITE_FILE." ".RESULT_XML_PATH;
		}
		return "";
	}

	function _createConnectInc()
	{
		$error = "";

		if (  !is_writable( "./cfg/connect.inc.php" )  )
			$error = "Couldn't rewrite file cfg/connect.inc.php.";
		else
		{
			$f = fopen("./cfg/connect.inc.php","w");
			$s = "<?php																					\n".
				"//database connection settings															\n".
				"define('DBMS', '".$_SESSION["dbms"]."');					// database system			\n".
				"define('DB_HOST', '".$_SESSION["databaseHost"]."');		// database host			\n".
				"define('DB_USER', '".$_SESSION["databaseUsername"]."');	// username					\n".
				"define('DB_PASS', '".$_SESSION["databasePassword"]."');	// password					\n".
				"define('DB_NAME', '".$_SESSION["databaseName"]."');		// database name			\n".
				"define('ADMIN_LOGIN', '".$_POST["adminLogin"]."');			// administrator's login	\n".
				"																						\n".
				"// include table name file																\n".
				"include('./cfg/tables.inc.php');														\n".
				"?>";
			fputs($f,$s);
			fclose($f);
		}
		return $error;
	}

	function _reWriteInstallXmlFile()
	{	
		ReWriteInstallXmlFile( 
							DATABASE_STRUCTURE_XML_PATH, 
							$_SESSION["tableFileName"], 
							RESULT_XML_PATH );
		unlink( DATABASE_STRUCTURE_XML_PATH );
		rename( RESULT_XML_PATH, DATABASE_STRUCTURE_XML_PATH );
	}

	function _installNewDataBase()
	{
		$tables = db_get_all_ss_tables( DATABASE_STRUCTURE_XML_PATH );
		foreach( $tables as $tableName )
			db_delete_table( $tableName );

		CreateTablesIncFile( "./cfg/tables.inc.php", DATABASE_STRUCTURE_XML_PATH );

		// rewrite "./cfg/connect.inc.php"
		$error = _createConnectInc();
		if ( $error != "" )
			die( "<center><font color=red>".$error."</font></center>" );

		// include connect file
		include( "./cfg/connect.inc.php" );

		// installation routine

		// create tables without constraints
		CreateTablesStructureXML( DATABASE_STRUCTURE_XML_PATH );

		//CreateTablesIncFile( "./cfg/tables.inc.php", DATABASE_STRUCTURE_XML_PATH );

		// settings
		serImportWithConstantNameReplacing( "./sql/setting_groups.sql" );
		serImportWithConstantNameReplacing( "./sql/setting_constants.sql", true );
		_initializeAuxPages();

		// c
		serImportWithConstantNameReplacing( "./sql/order_statuses.sql" );
		_setNewOrderStatus();
		_setCompletedStatus();
		
		if ( isset($_POST["generalDataCheckbox"]) )
		{
			// a
			serImportWithConstantNameReplacing( "./sql/localization.sql" );

			// b
			serImportWithConstantNameReplacing( "./sql/currencies.sql" );
			_setDefaultCurrency();

			// c

			// d
			serImportWithConstantNameReplacing( "./sql/customer_groups.sql" );
			_setCustGroupByDefault();

			// e
			serImportWithConstantNameReplacing( "./sql/shipping_methods.sql" );

			// f
			serImportWithConstantNameReplacing( "./sql/payment_types.sql" );
			_setPaymentShippingMethod();
		}

		if ( isset($_POST["exampleDataCheckbox"]) )
			serImportWithConstantNameReplacing( "./sql/demo_database.sql" );

		// create refer constraints
		$sql = CreateReferConstraintsXML( DATABASE_STRUCTURE_XML_PATH );

		settingDefineConstants();

		// register admin
		regRegisterAdmin( $_POST["adminLogin"], $_POST["adminPassword"] );
		regAuthenticate( $_POST["adminLogin"], $_POST["adminPassword"] );
		_sendByMail();
	}


	function _unsetDataBaseSessionVariables()
	{
			unset( $_SESSION["dbms"] );
			unset( $_SESSION["databaseHost"] );
			unset( $_SESSION["databaseUsername"] );
			unset( $_SESSION["databasePassword"] );
			unset( $_SESSION["databaseName"] );
	}

	function _upgradeOldDataBase()
	{
		/*
		get old admin login
		*/
		$OldAdminLogin = '';
		if(file_exists('./cfg/connect.inc.php')){
			
			$Buff = file_get_contents('./cfg/connect.inc.php');
			$SubPatterns = array();
			if(preg_match('|define[ ]*\([ \'\"]+ADMIN_LOGIN[ \'\"]+,[ \'\"]+(.+)[ \'\"]+\)\;|i', $Buff, $SubPatterns)){
				
				if(isset($SubPatterns[1])&&$SubPatterns[1]){
					
					$OldAdminLogin = $SubPatterns[1];
				}
			}
		}
		// rewrite "./cfg/connect.inc.php"
		$error = _createConnectInc();
		if ( $error != "" )
			die( "<center><font color=red>".$error."</font></center>" );

		// include connect file
		include( "./cfg/connect.inc.php" );

		// rewrite "./cfg/tables.inc.php"
		CreateTablesIncFile( "./cfg/tables.inc.php", DATABASE_STRUCTURE_XML_PATH );
		include( "./cfg/tables.inc.php" );

		if ( $_GET["upgrade"] == "free" )
		{
			UpgradeSSfree10_to_sspremium( $_POST["adminLogin"], $_POST["adminPassword"] );
			CallInstallFunctions();

			// settings
			serImportWithConstantNameReplacing( "./sql/setting_groups.sql" );
			serImportWithConstantNameReplacing( "./sql/setting_constants.sql", true );

			// b
			db_query("INSERT INTO ".CURRENCY_TYPES_TABLE." (CID, Name, code, currency_value, where2show, currency_iso_3) VALUES (1, 'US Dollars', 'US $', '1', 0, 'USD')");
			_setDefaultCurrency();
			
			// c
			serImportWithConstantNameReplacing( "./sql/order_statuses.sql" );
			_setNewOrderStatus();
			_setCompletedStatus();
			if ( isset($_POST["generalDataCheckbox"]) )
			{
				// a
				serImportWithConstantNameReplacing( "./sql/localization.sql" );

				// b

				// c

				// d
				serImportWithConstantNameReplacing( "./sql/customer_groups.sql" );
				_setCustGroupByDefault();

				// e
				serImportWithConstantNameReplacing( "./sql/shipping_methods.sql" );

				// f
				serImportWithConstantNameReplacing( "./sql/payment_types.sql" );
				_setPaymentShippingMethod();
			}

			_initializeAuxPages();
		}
		else if ($_GET["upgrade"] == "pro")
			{
				$is_20 = in_array(strtolower(SYSTEM_TABLE), db_get_all_tables());
				if(!$is_20){
					#from pro 1.0
					
					UpgradeSSpro10_to_sspremium( 1, 
												$_POST["adminLogin"], $_POST["adminPassword"] );
					CallInstallFunctions();
					
					// b
					serImportWithConstantNameReplacing( "./sql/order_statuses.sql" );
					_setNewOrderStatus();
					_setCompletedStatus();
					
					if ( isset($_POST["generalDataCheckbox"]) )
					{
						// a
						serImportWithConstantNameReplacing( "./sql/localization.sql" );
	
						// b
					}
	
					_initializeAuxPages();
				}else{
					
					#from pro 2.0
					$sql = "
						SELECT value FROM ".SYSTEM_TABLE."
						WHERE varName='version_name'
					";
					list($VersionName) = db_fetch_row(db_query($sql));
					if($VersionName != 'PREMIUM'){
						
						$sql = '
							SELECT value FROM '.SYSTEM_TABLE.'
							WHERE varName="version_number"
						';
						$VersionNumber = 0;
						list($VersionNumber) = db_fetch_row(db_query($sql));
						switch ($VersionNumber){
							case 2.00:
								require('./install/upgrade_sspro20_sspremium.php');
								break;
							case 2.10:
							case 2.11:
								$is_21  = true;
								require('./install/upgrade_sspro210_sspremium.php');
								break;
						}
					}
				}

				if(!isset($is_21)){
					
					$tables = db_get_all_tables();
					if(in_array('ss__module_payment_invoice_phys', $tables))
						db_query('ALTER TABLE SS__module_payment_invoice_phys ADD module_id INT NOT NULL');
					if(in_array('ss__module_payment_invoice_jur', $tables))
						db_query('ALTER TABLE SS__module_payment_invoice_jur ADD module_id INT NOT NULL');
					if(in_array('ss__module_shipping_bycountries_byzones_rates_percent', $tables))
						db_query('ALTER TABLE SS__module_shipping_bycountries_byzones_rates_percent ADD module_id INT NOT NULL');
					if(in_array('ss__module_shipping_bycountries_byzones_rates', $tables))
						db_query('ALTER TABLE SS__module_shipping_bycountries_byzones_rates ADD module_id INT NOT NULL');
				}
			}
			else if ($_GET["upgrade"] == "premium") //upgrading premium->premium
			{
				$version = verGetPackageVersion();
				if (!$version) die ("install.php: corrupted Shop-Script PREMIUM database (couldn't fetch version information)");

				if($version < 1.23){
					if ($version < 1.22)
					{
	
						if ($version <= 1.2)
						{
	
							if ($version <= 1.1)
							{
								// upgrade from v. 1.1 and older to 1.2
								db_query("alter table ".ORDERS_TABLE." modify cc_number varchar(255), modify cc_holdername varchar(255), modify cc_expires varchar(255), modify cc_cvv varchar(255)");
	
								// get database structure from XML file 
								$xmlNodeTableArray = GetXmlTableNodeArray( DATABASE_STRUCTURE_XML_PATH );
								// create missing tables
								for( $i=0; $i < count($xmlNodeTableArray);  $i++ )
								{
									$attr = $xmlNodeTableArray[$i]->GetXmlNodeAttributes();
									if ($attr["NAME"] == CUSTOMER_REG_FIELDS_VALUES_TABLE_QUICKREG )
									{
										$sql = GetCreateTableSQL( $xmlNodeTableArray[$i] );
										db_query( $sql );
									}
								}
							}
	
							//now upgrade 1.2 to 1.21
							//add lacking constants (settings)
							db_query( "delete from ".SETTINGS_TABLE." where settings_constant_name LIKE 'CONF_ADDRESSFORM_%'" );
	
	
						}
	
						//upgrade to 1.21 to 1.22
						//database structure
						/**
						 * new tables
						 */
							db_query("
								CREATE TABLE ".AFFILIATE_COMMISSIONS_TABLE." (
									cID int(11) NOT NULL auto_increment,
									Amount float default NULL,
									CurrencyISO3 char(3) default NULL,
									xDateTime datetime default NULL,
									Description varchar(255) default NULL,
									OrderID int(11) default NULL,
									CustomerID int(11) default NULL,
									PRIMARY KEY  (cID),
									KEY CUSTOMERID (CustomerID)
								)
							");
							db_query("
								CREATE TABLE ".AFFILIATE_PAYMENTS_TABLE." (
									pID int(11) NOT NULL auto_increment,
									CustomerID int(11) default NULL,
									Amount float default NULL,
									CurrencyISO3 char(3) default NULL,
									xDate date default NULL,
									Description varchar(255) default NULL,
									PRIMARY KEY  (pID),
									KEY CUSTOMERID (CustomerID)
								)					
							");
							db_query("
								CREATE TABLE ".LINK_EXCHANGE_CATEGORIES_TABLE." (
									le_cID int(11) NOT NULL auto_increment,
									le_cName varchar(100) default NULL,
									le_cSortOrder int(11) default NULL,
									PRIMARY KEY  (le_cID)
								)
							");
							db_query("
								CREATE TABLE ".LINK_EXCHANGE_LINKS_TABLE." (
									le_lID int(11) NOT NULL auto_increment,
									le_lText varchar(255) default NULL,
									le_lURL varchar(255) default NULL,
									le_lCategoryID int(11) default NULL,
									le_lVerified datetime default NULL,
									PRIMARY KEY  (le_lID)
								)
							");
						/**
						 * changes in tables
						 */
						db_query("ALTER TABLE ".CATEGORIES_TABLE." ADD meta_description VARCHAR(255)");
						db_query("ALTER TABLE ".CATEGORIES_TABLE." ADD meta_keywords VARCHAR(255)");
						db_query("ALTER TABLE ".CATEGORIES_TABLE." ADD INDEX IDX_CATEGORIES1(parent)");
						
						db_query("ALTER TABLE ".CUSTOMERS_TABLE." ADD affiliateID INT");
						db_query("ALTER TABLE ".CUSTOMERS_TABLE." ADD affiliateEmailOrders INT DEFAULT 1");
						db_query("ALTER TABLE ".CUSTOMERS_TABLE." ADD affiliateEmailPayments INT DEFAULT 1");
						db_query("ALTER TABLE ".CUSTOMERS_TABLE." ADD INDEX AFFILIATEID(affiliateID)");
						
						db_query("ALTER TABLE ".ORDER_STATUS_CHANGE_LOG_TABLE." ADD status_comment VARCHAR(255)");
						
						db_query("ALTER TABLE ".ORDERS_TABLE." ADD affiliateID INT");
						
					}
					
					/**
					 * upgrade from 1.22 to 1.23
					 */
					db_query('ALTER TABLE '.ORDERS_TABLE.' ADD shippingServiceInfo VARCHAR(255)');
					
					/**
					 * update modules
					 */
					db_query("ALTER TABLE ".MODULES_TABLE." ADD ModuleClassName VARCHAR(255) NOT NULL");
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_SELECT_BOX(CVeriSignLink::getTranstypeOptions()" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_VERISIGNLINK_TRANSTYPE"');
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_VERISIGNLINK_USD_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_RUPAY_USD_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_SELECT_BOX(CPSiGateHTML::getChargeTypeOptions()," WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_PSIGATEHTML_CHARGETYPE"');
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_PSIGATEHTML_USD_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_SELECT_BOX(CProtx::getModeOptions()," WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_PROTX_MODE"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_NETREGISTRY_DOLLAR_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_MALSE_CURR_TYPE"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_LINKPOINT_USD_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_INVOICE_PHYS_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_INVOICE_JUR_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_EGOLD_USD_CURRENCY"');
					
					db_query('UPDATE '.SETTINGS_TABLE.' SET settings_html_function="setting_CURRENCY_SELECT(" WHERE 
						settings_constant_name="CONF_PAYMENTMODULE_2CO_USD_CURRENCY"');
					
					$tables = db_get_all_tables();
					if(in_array('ss__module_payment_invoice_phys', $tables))
						db_query('ALTER TABLE SS__module_payment_invoice_phys ADD module_id INT NOT NULL');
					if(in_array('ss__module_payment_invoice_jur', $tables))
						db_query('ALTER TABLE SS__module_payment_invoice_jur ADD module_id INT NOT NULL');
					if(in_array('ss__module_shipping_bycountries_byzones_rates_percent', $tables))
						db_query('ALTER TABLE SS__module_shipping_bycountries_byzones_rates_percent ADD module_id INT NOT NULL');
					if(in_array('ss__module_shipping_bycountries_byzones_rates', $tables))
						db_query('ALTER TABLE SS__module_shipping_bycountries_byzones_rates ADD module_id INT NOT NULL');

				}
			}
			
		/**
		 * add new columns in tables
		 */
		updateTablesStructure();
		/**
		 * import new constants
		 */
		serImportConstWithChecking( "./sql/setting_constants.sql");
		// update package version
		verUpdatePackageVersion();
		verUpdatePackageName();

		// register admin
		settingDefineConstants();
		regRegisterAdmin( $_POST["adminLogin"], $_POST["adminPassword"] , true, $OldAdminLogin);
		regAuthenticate( $_POST["adminLogin"], $_POST["adminPassword"] );
	}

	function _sendByMail()
	{
		//void
	}

	function _setDefaultCurrency()
	{
		_setSettingOptionValue( "CONF_DEFAULT_CURRENCY", 1 );	
	}

	function _setNewOrderStatus()
	{
		_setSettingOptionValue( "CONF_NEW_ORDER_STATUS", 2 );
	}

	function _setCompletedStatus()
	{
		_setSettingOptionValue( "CONF_COMPLETED_ORDER_STATUS", 5 );
	}

	function _setCustGroupByDefault()
	{
		_setSettingOptionValue( "CONF_DEFAULT_CUSTOMER_GROUP", 1 );
	}

	function _setPaymentShippingMethod()
	{
		payResetPaymentShippingMethods( 1 );
		paySetPaymentShippingMethod( 1, 1 );
		paySetPaymentShippingMethod( 1, 2 );
		paySetPaymentShippingMethod( 1, 3 );
		paySetPaymentShippingMethod( 1, 4 );
		paySetPaymentShippingMethod( 1, 5 );

		payResetPaymentShippingMethods( 2 );
		paySetPaymentShippingMethod( 2, 1 );
		paySetPaymentShippingMethod( 2, 2 );
		paySetPaymentShippingMethod( 2, 3 );
		paySetPaymentShippingMethod( 2, 4 );
		paySetPaymentShippingMethod( 2, 5 );

		payResetPaymentShippingMethods( 3 );
		paySetPaymentShippingMethod( 3, 1 );
		paySetPaymentShippingMethod( 3, 2 );
		paySetPaymentShippingMethod( 3, 3 );
		paySetPaymentShippingMethod( 3, 4 );
		paySetPaymentShippingMethod( 3, 5 );

		payResetPaymentShippingMethods( 4 );
		paySetPaymentShippingMethod( 4, 1 );
		paySetPaymentShippingMethod( 4, 2 );
		paySetPaymentShippingMethod( 4, 3 );
		paySetPaymentShippingMethod( 4, 4 );
		paySetPaymentShippingMethod( 4, 5 );


		payResetPaymentShippingMethods( 5 );
		paySetPaymentShippingMethod( 5, 1 );
		paySetPaymentShippingMethod( 5, 2 );
		paySetPaymentShippingMethod( 5, 3 );
		paySetPaymentShippingMethod( 5, 4 );
		paySetPaymentShippingMethod( 5, 5 );
	}

	function _initializeAuxPages()
	{
		$aux_page_text =
			"<h1>Information page #1</h1>Your text here";
		auxpgAddAuxPage( 	"About your shopping cart", 
				$aux_page_text, 1,
				"", "" );

		$aux_page_text =
			"<h1>Information page #2</h1>Your text here";
		auxpgAddAuxPage( 	"Shipping and payment", 
				$aux_page_text, 1,
				"", "" );
	}


	// init Smarty
	require 'smarty/smarty.class.php'; 
	$smarty			= new Smarty;
	$smarty->template_dir = "./install";


	if ( isset($_GET["install_is_completed"]) )
		$smarty->display( "successful_install.tpl.html" );
	else if ( !isset($_GET["license"]) )
	{
		if ( !isset($_GET["step"])  )
			$_GET["step"] = 1;

		if ( $_GET["step"] != 1 && $_GET["step"] != 2 && $_GET["step"] != 3 )		
			$_GET["step"] = 1;

		switch( $_GET["step"] )
		{
			case 1:
				$smarty->display( "step1.tpl.html" );
				break;

			case 2:

				$error=_testWriteable();

				if ( ($error=_testWriteable()) != "" )
					$smarty->assign( "file_is_not_writeable", $error );
				else
				{

					if ( isset($_POST["next"]) )
					{
						$smarty->assign( "databaseHost",		$_POST["_databaseHost"] );
						$smarty->assign( "databaseUsername",	$_POST["_databaseUsername"] );
						$smarty->assign( "databasePassword",	$_POST["_databasePassword"] );
						$smarty->assign( "databaseName",		$_POST["_databaseName"] );
						$smarty->assign( "dbms",				$_POST["_dbms"] );

						if ( !file_exists( "./includes/database/".$_POST["_dbms"].".php" ) )
						{
							die ("Couldn't find database functions file (includes/database/".$_POST["_dbms"].".php)<br>Please reupload Shop-Script archive to your server.");
						}
						else
							include( "./includes/database/".$_POST["_dbms"].".php" );

						$res = db_connect( $_POST["_databaseHost"], $_POST["_databaseUsername"], 
							$_POST["_databasePassword"] );

						if ( is_bool( $res ) )
						{
							$smarty->assign( "errorCode", 1 );
							$smarty->display( "step2.tpl.html" );
							exit;
						}
					
						$res = db_select_db( $_POST["_databaseName"] );
						if ( !$res )
						{
							$smarty->assign( "errorCode", 2 );
							$smarty->display( "step2.tpl.html" );
							exit;
						}

						// it must be encrypted !!!!!!!!!!!!!!!!!
						$_SESSION["dbms"]				= $_POST["_dbms"];
						$_SESSION["databaseHost"]		= $_POST["_databaseHost"];
						$_SESSION["databaseUsername"]	= $_POST["_databaseUsername"];
						$_SESSION["databasePassword"]	= $_POST["_databasePassword"];
						$_SESSION["databaseName"]		= $_POST["_databaseName"];
						if ( isset($_FILES["tableFileName"]) && 
										isset($_FILES["tableFileName"]["name"]) )
						{
							if ( trim($_FILES["tableFileName"]["name"]) != "" )
							{
								$file_name = str_replace(" ","_", $_FILES["tableFileName"]["name"]);
								move_uploaded_file( 
										$_FILES["tableFileName"]["tmp_name"], 
										"./temp/".$file_name );
								SetRightsToUploadedFile( "./temp/".$file_name );
								$_SESSION["tableFileName"] = "./temp/".$file_name;
							}
						}
						// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		
						if ( !isset($_GET["upgrade"]) )
							RedirectJavaScript( "install.php?step=3" );
						else
							RedirectJavaScript( "install.php?step=3&upgrade=".$_GET["upgrade"] );
					}
					if ( isset($_GET["upgrade"]) )
						$smarty->assign( "upgrade", $_GET["upgrade"] );
				}
				$smarty->display( "step2.tpl.html" );
				break;

			case 3:	
				
				if ( !isset($_SESSION["dbms"]) )
					Redirect( "install.php" );

				if ( !file_exists("./includes/database/".$_SESSION["dbms"].".php") )
					Redirect( "install.php" );

				// include database access function
				include( "./includes/database/".$_SESSION["dbms"].".php" );

				// connect to DBMS
				db_connect( $_SESSION["databaseHost"], $_SESSION["databaseUsername"], 
											$_SESSION["databasePassword"] );

				// select database name
				db_select_db( $_SESSION["databaseName"] );

				if ( !isset($_GET["upgrade"]) )
				{
					$tables = db_get_all_ss_tables( DATABASE_STRUCTURE_XML_PATH );
					$smarty->assign( "tables", $tables );

					if ( isset($_POST["install"]) )
					{	
						_installNewDataBase();
						_unsetDataBaseSessionVariables();
						Redirect( "install.php?install_is_completed=yes" );
					}
				}
				else
				{
					if ( isset($_POST["install"]) )
					{
						if ( isset($_SESSION["tableFileName"]) )
							_reWriteInstallXmlFile();

						_upgradeOldDataBase();
						_unsetDataBaseSessionVariables();
						Redirect( "install.php?install_is_completed=yes" );
					}
				}
				if ( isset($_GET["upgrade"]) )
					$smarty->assign( "upgrade", $_GET["upgrade"] );
				$smarty->display( "step3.tpl.html" );
				break;
		}
	}
	else
		$smarty->display( "license.html"  );

?>